<?php
/**
 * Field: Color Picker
 *
 * @since 1.1.0
 *
 * @package RBMFieldHelpers
 */

defined( 'ABSPATH' ) || die();

/**
 * Class RBM_FH_Field_ColorPicker
 *
 * @since 1.1.0
 */
class RBM_FH_Field_ColorPicker extends RBM_FH_Field {

	/**
	 * Field defaults.
	 *
	 * @since 1.1.0
	 *
	 * @var array
	 */
	public $defaults = array(
		'default' => '#fff',
		'colorpicker_options' => array(),
	);

	/**
	 * RBM_FH_Field_ColorPicker constructor.
	 *
	 * @since 1.1.0
	 *
	 * @var string $name
	 * @var array $args
	 * @var mixed $value
	 */
	function __construct( $name, $args = array() ) {

		parent::__construct( $name, $args );
	}

	/**
	 * Outputs the field.
	 *
	 * @since 1.1.0
	 *
	 * @param string $name Name of the field.
	 * @param mixed $value Value of the field.
	 * @param array $args Field arguments.
	 */
	public static function field( $name, $value, $args = array() ) {
		
		wp_enqueue_script( 'wp-color-picker' );

		do_action( "{$args['prefix']}_fieldhelpers_do_field", 'colorpicker', $args, $name, $value );
	}
}